package kb.presentation;

// Imports enhydra
import org.enhydra.xml.xmlc.*;
import org.w3c.dom.*;
import org.w3c.dom.html.*;
import com.lutris.appserver.server.sql.*;
import com.lutris.appserver.server.Enhydra;
import com.lutris.appserver.server.httpPresentation.*;
import com.lutris.logging.*;
import kb.data.*;
import kb.business.*;
import kb.presentation.*;

public class Result extends BasePO {
  protected LogChannel log = Enhydra.getLogChannel();

  public void run(HttpPresentationComms comms) 
              throws HttpPresentationException {
    // Rcupre les paramtres dans la requte HTTP
    String lstype = comms.request.getParameter("type");
    String lstitre = comms.request.getParameter("titre");
    String lscontenu = comms.request.getParameter("contenu");
    // Rcupre les noms correspondants
    kbManager pm = new kbManager();
    InfoDO[] list = pm.getNames(lstype, lstitre, lscontenu);
    ResultPage result = (ResultPage) create(comms, "kb.presentation.Result");
    // Rcupre les informations ncessaires de ce document
    Element template = result.getTagInfoTemplate();
    Node templateParent = template.getParentNode();
    // Retire les attributs id
    template.removeAttribute("id");
    if (list == null || list.length == 0) {
      // Si la requte ne retourne aucun rsultat, rcupre les rsultats et les remplace par un message d'erreur
      Node errMsg = result.createElement("em");
      errMsg.appendChild (result.createTextNode("Aucune information trouve."));
      templateParent.replaceChild(errMsg, template);
      comms.response.writeDOM(result);
      return;
    } 
    // Parcours la liste retourne
    try {
      for (int i = 0; i < list.length; i++) {
        String name = list[i].getType() + " " + list[i].getTitre();
        StringBuffer infoLink = new StringBuffer();
        infoLink.append("Details.po?id=");
        infoLink.append(list[i].getHandle());
        result.setTextInfoTemplate(name);
        template.getAttributeNode("href").setValue(infoLink.toString());
        // Ajoute cela  la liste de liens
        templateParent.appendChild(template.cloneNode(true));
        templateParent.appendChild(result.createElement("br"));
      } 
      // Retire le template
      templateParent.removeChild(template);
    } catch (Exception e) {
      e.printStackTrace(System.out);
      log.write(Logger.CRITICAL, "Error in getting DOs");
      log.write(Logger.CRITICAL, e.toString());
    } 
    // L'affiche
    comms.response.writeDOM(result);
  } 
}
